#!/bin/bash
CURRENT_DIR=$(dirname "$0")
cd "$CURRENT_DIR"

# Find all subdirectories and run their sync.sh scripts if they exist
for dir in */; do
    if [ -f "${dir}sync.sh" ]; then
        echo "Running ${dir}sync.sh"
        ./${dir}sync.sh
    fi
done

sudo -u garg -H git add --all
sudo -u garg -H git commit -m "sync at $(date)"
sudo -u garg -H git push origin master