import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
const _excluded = ["componentFamily", "render", "renderWithProps", "values", "emptyValue", "setNewValue"];
import * as React from 'react';
import { expect } from 'chai';
import { spy } from 'sinon';
import { expectPickerChangeHandlerValue } from 'test/utils/pickers';
import { userEvent, screen } from '@mui/monorepo/test/utils';
import { jsx as _jsx } from "react/jsx-runtime";
export const testShortcuts = (ElementToTest, options) => {
  const {
      componentFamily,
      render,
      values
    } = options,
    pickerParams = _objectWithoutPropertiesLoose(options, _excluded);
  if (componentFamily !== 'picker') {
    return;
  }
  describe('Picker shortcuts', () => {
    it('should call onClose, onChange and onAccept when picking a shortcut without explicit changeImportance', () => {
      const onChange = spy();
      const onAccept = spy();
      const onClose = spy();
      render( /*#__PURE__*/_jsx(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: () => values[1]
            }]
          }
        }
      }));
      const shortcut = screen.getByRole('button', {
        name: 'Test shortcut'
      });
      userEvent.mousePress(shortcut);
      expect(onChange.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onChange, values[1]);
      expect(onAccept.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onAccept, values[1]);
      expect(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onChange when picking a shortcut with changeImportance="accept"', () => {
      const onChange = spy();
      const onAccept = spy();
      const onClose = spy();
      render( /*#__PURE__*/_jsx(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: () => values[1]
            }],
            changeImportance: 'accept'
          }
        }
      }));
      const shortcut = screen.getByRole('button', {
        name: 'Test shortcut'
      });
      userEvent.mousePress(shortcut);
      expect(onChange.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onChange, values[1]);
      expect(onAccept.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onAccept, values[1]);
      expect(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onChange when picking a shortcut with changeImportance="set"', () => {
      const onChange = spy();
      const onAccept = spy();
      const onClose = spy();
      render( /*#__PURE__*/_jsx(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: () => values[1]
            }],
            changeImportance: 'set'
          }
        }
      }));
      const shortcut = screen.getByRole('button', {
        name: 'Test shortcut'
      });
      userEvent.mousePress(shortcut);
      expect(onChange.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onChange, values[1]);
      expect(onAccept.callCount).to.equal(0);
      expect(onClose.callCount).to.equal(0);
    });
  });
};