"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describeValidation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _createDescribe = _interopRequireDefault(require("@mui/monorepo/test/utils/createDescribe"));
var _testDayViewValidation = require("./testDayViewValidation");
var _testMonthViewValidation = require("./testMonthViewValidation");
var _testTextFieldValidation = require("./testTextFieldValidation");
var _testYearViewValidation = require("./testYearViewValidation");
var _testMinutesViewValidation = require("./testMinutesViewValidation");
/* eslint-env mocha */

const TEST_SUITES = [_testYearViewValidation.testYearViewValidation, _testMonthViewValidation.testMonthViewValidation, _testDayViewValidation.testDayViewValidation, _testMinutesViewValidation.testMinutesViewValidation, _testTextFieldValidation.testTextFieldValidation];
function innerDescribeValidation(ElementToTest, getOptions) {
  const {
    after: runAfterHook = () => {},
    views
  } = getOptions();
  after(runAfterHook);
  function getTestOptions() {
    return (0, _extends2.default)({}, getOptions(), {
      withDate: views.includes('year') || views.includes('month') || views.includes('day'),
      withTime: views.includes('hours') || views.includes('minutes') || views.includes('seconds')
    });
  }
  TEST_SUITES.forEach(testSuite => {
    testSuite(ElementToTest, getTestOptions);
  });
}

/**
 * Tests various aspects of the picker validation.
 */
const describeValidation = (0, _createDescribe.default)('Pickers validation API', innerDescribeValidation);
exports.describeValidation = describeValidation;