"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testLocalization = void 0;
var _chai = require("chai");
const testLocalization = ({
  adapter
}) => {
  it('Method: formatNumber', () => {
    (0, _chai.expect)(adapter.formatNumber('1')).to.equal('۱');
    (0, _chai.expect)(adapter.formatNumber('2')).to.equal('۲');
  });
  it('Method: getMeridiemText', () => {
    (0, _chai.expect)(adapter.getMeridiemText('am')).to.equal('ق.ظ');
    (0, _chai.expect)(adapter.getMeridiemText('pm')).to.equal('ب.ظ');
  });
  it('Method: getFormatHelperText', () => {
    (0, _chai.expect)(adapter.getFormatHelperText(adapter.formats.keyboardDate)).to.equal('yyyy/mm/dd');
    (0, _chai.expect)(adapter.getFormatHelperText(adapter.formats.keyboardDateTime12h)).to.equal('yyyy/mm/dd hh:mm (a|p)m');
  });
  it('Method: getCurrentLocaleCode', () => {
    // Returns the default locale
    (0, _chai.expect)(adapter.getCurrentLocaleCode()).to.match(/fa/);
  });
};
exports.testLocalization = testLocalization;