import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
var _excluded = ["componentFamily", "render", "renderWithProps", "values", "emptyValue", "setNewValue"];
import * as React from 'react';
import { expect } from 'chai';
import { spy } from 'sinon';
import { expectPickerChangeHandlerValue } from 'test/utils/pickers';
import { userEvent, screen } from '@mui/monorepo/test/utils';
import { jsx as _jsx } from "react/jsx-runtime";
export var testShortcuts = function testShortcuts(ElementToTest, options) {
  var componentFamily = options.componentFamily,
    render = options.render,
    renderWithProps = options.renderWithProps,
    values = options.values,
    emptyValue = options.emptyValue,
    setNewValue = options.setNewValue,
    pickerParams = _objectWithoutProperties(options, _excluded);
  if (componentFamily !== 'picker') {
    return;
  }
  describe('Picker shortcuts', function () {
    it('should call onClose, onChange and onAccept when picking a shortcut without explicit changeImportance', function () {
      var onChange = spy();
      var onAccept = spy();
      var onClose = spy();
      render( /*#__PURE__*/_jsx(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: function getValue() {
                return values[1];
              }
            }]
          }
        }
      }));
      var shortcut = screen.getByRole('button', {
        name: 'Test shortcut'
      });
      userEvent.mousePress(shortcut);
      expect(onChange.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onChange, values[1]);
      expect(onAccept.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onAccept, values[1]);
      expect(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onChange when picking a shortcut with changeImportance="accept"', function () {
      var onChange = spy();
      var onAccept = spy();
      var onClose = spy();
      render( /*#__PURE__*/_jsx(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: function getValue() {
                return values[1];
              }
            }],
            changeImportance: 'accept'
          }
        }
      }));
      var shortcut = screen.getByRole('button', {
        name: 'Test shortcut'
      });
      userEvent.mousePress(shortcut);
      expect(onChange.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onChange, values[1]);
      expect(onAccept.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onAccept, values[1]);
      expect(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onChange when picking a shortcut with changeImportance="set"', function () {
      var onChange = spy();
      var onAccept = spy();
      var onClose = spy();
      render( /*#__PURE__*/_jsx(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: function getValue() {
                return values[1];
              }
            }],
            changeImportance: 'set'
          }
        }
      }));
      var shortcut = screen.getByRole('button', {
        name: 'Test shortcut'
      });
      userEvent.mousePress(shortcut);
      expect(onChange.callCount).to.equal(1);
      expectPickerChangeHandlerValue(pickerParams.type, onChange, values[1]);
      expect(onAccept.callCount).to.equal(0);
      expect(onClose.callCount).to.equal(0);
    });
  });
};