"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describeValue = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));
var React = _interopRequireWildcard(require("react"));
var _createDescribe = _interopRequireDefault(require("@mui/monorepo/test/utils/createDescribe"));
var _pickers = require("test/utils/pickers");
var _testControlledUnControlled = require("./testControlledUnControlled");
var _testPickerOpenCloseLifeCycle = require("./testPickerOpenCloseLifeCycle");
var _testPickerActionBar = require("./testPickerActionBar");
var _testShortcuts = require("./testShortcuts");
var _jsxRuntime = require("react/jsx-runtime");
const _excluded = ["hook"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const TEST_SUITES = [_testControlledUnControlled.testControlledUnControlled, _testPickerOpenCloseLifeCycle.testPickerOpenCloseLifeCycle, _testPickerActionBar.testPickerActionBar, _testShortcuts.testShortcuts];
function innerDescribeValue(ElementToTest, getOptions) {
  const options = getOptions();
  const {
    defaultProps,
    render,
    clock,
    componentFamily
  } = options;
  function WrappedElementToTest(props) {
    const {
        hook
      } = props,
      other = (0, _objectWithoutPropertiesLoose2.default)(props, _excluded);
    const hookResult = hook?.(props);
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, other, hookResult));
  }
  let renderWithProps;
  if (componentFamily === 'field' || componentFamily === 'picker') {
    const interactions = (0, _pickers.buildFieldInteractions)({
      clock,
      render,
      Component: ElementToTest
    });
    renderWithProps = (props, hook) => interactions.renderWithProps((0, _extends2.default)({}, defaultProps, props), hook, componentFamily);
  } else {
    renderWithProps = (props, hook) => {
      const response = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WrappedElementToTest, (0, _extends2.default)({}, props, {
        hook: hook
      })));
      return (0, _extends2.default)({}, response, {
        input: null,
        selectSection: () => {
          throw new Error('You can only select a section on components that render a field');
        }
      });
    };
  }
  TEST_SUITES.forEach(testSuite => {
    testSuite(WrappedElementToTest, (0, _extends2.default)({}, options, {
      renderWithProps
    }));
  });
}
/**
 * Tests various aspects of component value.
 */
const describeValue = (0, _createDescribe.default)('Value API', innerDescribeValue);
exports.describeValue = describeValue;