import _extends from "@babel/runtime/helpers/esm/extends";
import createDescribe from '@mui/monorepo/test/utils/createDescribe';
import { testCalculations } from './testCalculations';
import { testLocalization } from './testLocalization';
import { testFormat } from './testFormat';
function innerGregorianDescribeAdapter(Adapter, params) {
  var _params$prepareAdapte;
  const prepareAdapter = (_params$prepareAdapte = params.prepareAdapter) != null ? _params$prepareAdapte : e => e;
  const adapter = new Adapter();
  const adapterTZ = params.dateLibInstanceWithTimezoneSupport ? new Adapter({
    dateLibInstance: params.dateLibInstanceWithTimezoneSupport
  }) : new Adapter();
  const adapterFr = new Adapter({
    locale: params.frenchLocale,
    dateLibInstance: params.dateLibInstanceWithTimezoneSupport
  });
  prepareAdapter(adapter);
  prepareAdapter(adapterTZ);
  describe(adapter.lib, () => {
    const testSuitParams = _extends({}, params, {
      adapter,
      adapterTZ,
      adapterFr
    });
    testCalculations(testSuitParams);
    testLocalization(testSuitParams);
    testFormat(testSuitParams);
  });
}
export const describeGregorianAdapter = createDescribe('Adapter methods', innerGregorianDescribeAdapter);