"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testPickerActionBar = void 0;
var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _sinon = require("sinon");
var _utils = require("@mui/monorepo/test/utils");
var _pickers = require("test/utils/pickers");
var _jsxRuntime = require("react/jsx-runtime");
const _excluded = ["componentFamily", "render", "renderWithProps", "values", "emptyValue", "setNewValue"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testPickerActionBar = (ElementToTest, options) => {
  const {
      componentFamily,
      render,
      renderWithProps,
      values,
      emptyValue,
      setNewValue
    } = options,
    pickerParams = (0, _objectWithoutPropertiesLoose2.default)(options, _excluded);
  if (componentFamily !== 'picker') {
    return;
  }
  describe('Picker action bar', () => {
    describe('clear action', () => {
      it('should call onClose, onChange with empty value and onAccept with empty value', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          defaultValue: values[0],
          open: true,
          slotProps: {
            actionBar: {
              actions: ['clear']
            }
          }
        }));

        // Clear the date
        _utils.userEvent.mousePress(_utils.screen.getByText(/clear/i));
        (0, _chai.expect)(onChange.callCount).to.equal(1);
        (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onChange, emptyValue);
        (0, _chai.expect)(onAccept.callCount).to.equal(1);
        (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onAccept, emptyValue);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
      it('should not call onChange or onAccept if the value is already empty value', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          slotProps: {
            actionBar: {
              actions: ['clear']
            }
          },
          value: emptyValue
        }));

        // Clear the date
        _utils.userEvent.mousePress(_utils.screen.getByText(/clear/i));
        (0, _chai.expect)(onChange.callCount).to.equal(0);
        (0, _chai.expect)(onAccept.callCount).to.equal(0);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
    });
    describe('cancel action', () => {
      it('should call onClose and onChange with the initial value', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        const {
          selectSection
        } = renderWithProps({
          onChange,
          onAccept,
          onClose,
          open: true,
          value: values[0],
          slotProps: {
            actionBar: {
              actions: ['cancel']
            }
          },
          closeOnSelect: false
        });

        // Change the value (already tested)
        setNewValue(values[0], {
          isOpened: true,
          selectSection
        });

        // Cancel the modifications
        _utils.userEvent.mousePress(_utils.screen.getByText(/cancel/i));
        (0, _chai.expect)(onChange.callCount).to.equal((0, _pickers.getExpectedOnChangeCount)(componentFamily, pickerParams) + 1);
        if (pickerParams.type === 'date-range') {
          values[0].forEach((value, index) => {
            (0, _chai.expect)(onChange.lastCall.args[0][index]).toEqualDateTime(value);
          });
        } else {
          (0, _chai.expect)(onChange.lastCall.args[0]).toEqualDateTime(values[0]);
        }
        (0, _chai.expect)(onAccept.callCount).to.equal(0);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
      it('should not call onChange if no prior value modification', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          value: values[0],
          slotProps: {
            actionBar: {
              actions: ['cancel']
            }
          },
          closeOnSelect: false
        }));

        // Cancel the modifications
        _utils.userEvent.mousePress(_utils.screen.getByText(/cancel/i));
        (0, _chai.expect)(onChange.callCount).to.equal(0);
        (0, _chai.expect)(onAccept.callCount).to.equal(0);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
    });
    describe('confirm action', () => {
      it('should call onClose and onAccept with the live value', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        const {
          selectSection
        } = renderWithProps({
          onChange,
          onAccept,
          onClose,
          open: true,
          defaultValue: values[0],
          slotProps: {
            actionBar: {
              actions: ['accept']
            }
          },
          closeOnSelect: false
        });

        // Change the value (already tested)
        setNewValue(values[0], {
          isOpened: true,
          selectSection
        });

        // Accept the modifications
        _utils.userEvent.mousePress(_utils.screen.getByText(/ok/i));
        (0, _chai.expect)(onChange.callCount).to.equal((0, _pickers.getExpectedOnChangeCount)(componentFamily, pickerParams)); // The accepted value as already been committed, don't call onChange again
        (0, _chai.expect)(onAccept.callCount).to.equal(1);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
      it('should call onChange, onClose and onAccept when validating the default value', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          defaultValue: values[0],
          slotProps: {
            actionBar: {
              actions: ['accept']
            }
          },
          closeOnSelect: false
        }));

        // Accept the modifications
        _utils.userEvent.mousePress(_utils.screen.getByText(/ok/i));
        (0, _chai.expect)(onChange.callCount).to.equal(1);
        (0, _chai.expect)(onAccept.callCount).to.equal(1);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
      it('should call onClose but not onAccept when validating an already validated value', () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          value: values[0],
          slotProps: {
            actionBar: {
              actions: ['accept']
            }
          },
          closeOnSelect: false
        }));

        // Accept the modifications
        _utils.userEvent.mousePress(_utils.screen.getByText(/ok/i));
        (0, _chai.expect)(onChange.callCount).to.equal(0);
        (0, _chai.expect)(onAccept.callCount).to.equal(0);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
    });
    describe('today action', () => {
      it("should call onClose, onChange with today's value and onAccept with today's value", () => {
        const onChange = (0, _sinon.spy)();
        const onAccept = (0, _sinon.spy)();
        const onClose = (0, _sinon.spy)();
        render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          defaultValue: values[0],
          open: true,
          slotProps: {
            actionBar: {
              actions: ['today']
            }
          }
        }));
        _utils.userEvent.mousePress(_utils.screen.getByText(/today/i));
        let startOfToday;
        if (pickerParams.type === 'date') {
          startOfToday = _pickers.adapterToUse.startOfDay(_pickers.adapterToUse.date());
        } else if (pickerParams.type === 'date-range') {
          startOfToday = [_pickers.adapterToUse.date(), _pickers.adapterToUse.date()];
        } else {
          startOfToday = _pickers.adapterToUse.date();
        }
        (0, _chai.expect)(onChange.callCount).to.equal(1);
        (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onChange, startOfToday);
        (0, _chai.expect)(onAccept.callCount).to.equal(1);
        (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onAccept, startOfToday);
        (0, _chai.expect)(onClose.callCount).to.equal(1);
      });
    });
  });
};
exports.testPickerActionBar = testPickerActionBar;