"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testShortcuts = void 0;
var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _sinon = require("sinon");
var _pickers = require("test/utils/pickers");
var _utils = require("@mui/monorepo/test/utils");
var _jsxRuntime = require("react/jsx-runtime");
const _excluded = ["componentFamily", "render", "renderWithProps", "values", "emptyValue", "setNewValue"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testShortcuts = (ElementToTest, options) => {
  const {
      componentFamily,
      render,
      values
    } = options,
    pickerParams = (0, _objectWithoutPropertiesLoose2.default)(options, _excluded);
  if (componentFamily !== 'picker') {
    return;
  }
  describe('Picker shortcuts', () => {
    it('should call onClose, onChange and onAccept when picking a shortcut without explicit changeImportance', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: () => values[1]
            }]
          }
        }
      }));
      const shortcut = _utils.screen.getByRole('button', {
        name: 'Test shortcut'
      });
      _utils.userEvent.mousePress(shortcut);
      (0, _chai.expect)(onChange.callCount).to.equal(1);
      (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onChange, values[1]);
      (0, _chai.expect)(onAccept.callCount).to.equal(1);
      (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onAccept, values[1]);
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onChange when picking a shortcut with changeImportance="accept"', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: () => values[1]
            }],
            changeImportance: 'accept'
          }
        }
      }));
      const shortcut = _utils.screen.getByRole('button', {
        name: 'Test shortcut'
      });
      _utils.userEvent.mousePress(shortcut);
      (0, _chai.expect)(onChange.callCount).to.equal(1);
      (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onChange, values[1]);
      (0, _chai.expect)(onAccept.callCount).to.equal(1);
      (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onAccept, values[1]);
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onChange when picking a shortcut with changeImportance="set"', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true,
        slotProps: {
          shortcuts: {
            items: [{
              label: 'Test shortcut',
              getValue: () => values[1]
            }],
            changeImportance: 'set'
          }
        }
      }));
      const shortcut = _utils.screen.getByRole('button', {
        name: 'Test shortcut'
      });
      _utils.userEvent.mousePress(shortcut);
      (0, _chai.expect)(onChange.callCount).to.equal(1);
      (0, _pickers.expectPickerChangeHandlerValue)(pickerParams.type, onChange, values[1]);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);
    });
  });
};
exports.testShortcuts = testShortcuts;