"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describePicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _sinon = require("sinon");
var _utils = require("@mui/monorepo/test/utils");
var _SvgIcon = _interopRequireDefault(require("@mui/material/SvgIcon"));
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/* eslint-env mocha */

function innerDescribePicker(ElementToTest, options) {
  const {
    render,
    fieldType,
    hasNoView,
    variant
  } = options;
  const propsToOpen = variant === 'static' ? {} : {
    open: true
  };
  it('should forward the `inputRef` prop to the text field', function test() {
    if (fieldType === 'multi-input' || variant === 'static') {
      this.skip();
    }
    const inputRef = /*#__PURE__*/React.createRef();
    render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
      inputRef: inputRef
    }));
    (0, _chai.expect)(inputRef.current).to.have.tagName('input');
  });
  describe('Localization', () => {
    it('should respect the `localeText` prop', function test() {
      if (hasNoView) {
        this.skip();
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, propsToOpen, {
        localeText: {
          cancelButtonLabel: 'Custom cancel'
        },
        slotProps: {
          actionBar: {
            actions: ['cancel']
          }
        }
      })));
      (0, _chai.expect)(_utils.screen.queryByText('Custom cancel')).not.to.equal(null);
    });
  });
  describe('Component slot: OpenPickerIcon', () => {
    it('should render custom component', function test() {
      if (variant === 'static' || fieldType === 'multi-input') {
        this.skip();
      }
      function HomeIcon(props) {
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(_SvgIcon.default, (0, _extends2.default)({
          "data-testid": "component-test"
        }, props, {
          children: /*#__PURE__*/(0, _jsxRuntime.jsx)("path", {
            d: "M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"
          })
        }));
      }
      const {
        queryAllByTestId
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        slots: {
          openPickerIcon: HomeIcon
        }
      }));
      const shouldRenderOpenPickerIcon = !hasNoView && variant !== 'mobile';
      (0, _chai.expect)(queryAllByTestId('component-test')).to.have.length(shouldRenderOpenPickerIcon ? 1 : 0);
    });
  });
  describe('Component slot: DesktopPaper', () => {
    it('should forward onClick and onTouchStart', function test() {
      if (hasNoView || variant !== 'desktop') {
        this.skip();
      }
      const handleClick = (0, _sinon.spy)();
      const handleTouchStart = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, propsToOpen, {
        slotProps: {
          desktopPaper: {
            onClick: handleClick,
            onTouchStart: handleTouchStart,
            'data-testid': 'paper'
          }
        }
      })));
      const paper = _utils.screen.getByTestId('paper');
      _utils.fireEvent.click(paper);
      _utils.fireEvent.touchStart(paper);
      (0, _chai.expect)(handleClick.callCount).to.equal(1);
      (0, _chai.expect)(handleTouchStart.callCount).to.equal(1);
    });
  });
  describe('Component slot: Popper', () => {
    it('should forward onClick and onTouchStart', function test() {
      if (hasNoView || variant !== 'desktop') {
        this.skip();
      }
      const handleClick = (0, _sinon.spy)();
      const handleTouchStart = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, propsToOpen, {
        slotProps: {
          popper: {
            onClick: handleClick,
            onTouchStart: handleTouchStart,
            'data-testid': 'popper'
          }
        }
      })));
      const popper = _utils.screen.getByTestId('popper');
      _utils.fireEvent.click(popper);
      _utils.fireEvent.touchStart(popper);
      (0, _chai.expect)(handleClick.callCount).to.equal(1);
      (0, _chai.expect)(handleTouchStart.callCount).to.equal(1);
    });
  });
  describe('Component slot: Toolbar', () => {
    it('should render toolbar on mobile but not on desktop when `hidden` is not defined', function test() {
      if (hasNoView) {
        this.skip();
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, propsToOpen)));
      if (variant === 'desktop') {
        (0, _chai.expect)(_utils.screen.queryByMuiTest('picker-toolbar')).to.equal(null);
      } else {
        (0, _chai.expect)(_utils.screen.getByMuiTest('picker-toolbar')).toBeVisible();
      }
    });
    it('should render toolbar when `hidden` is `false`', function test() {
      if (hasNoView) {
        this.skip();
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, propsToOpen, {
        slotProps: {
          toolbar: {
            hidden: false
          }
        }
      })));
      (0, _chai.expect)(_utils.screen.getByMuiTest('picker-toolbar')).toBeVisible();
    });
    it('should not render toolbar when `hidden` is `true`', function test() {
      if (hasNoView) {
        this.skip();
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, propsToOpen, {
        slotProps: {
          toolbar: {
            hidden: true
          }
        }
      })));
      (0, _chai.expect)(_utils.screen.queryByMuiTest('picker-toolbar')).to.equal(null);
    });
  });
}

/**
 * Test behaviors shared across all pickers.
 */
const describePicker = (0, _utils.createDescribe)('Pickers shared APIs', innerDescribePicker);
exports.describePicker = describePicker;