"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describeGregorianAdapter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _createDescribe = _interopRequireDefault(require("@mui/monorepo/test/utils/createDescribe"));
var _testCalculations = require("./testCalculations");
var _testLocalization = require("./testLocalization");
var _testFormat = require("./testFormat");
function innerGregorianDescribeAdapter(Adapter, params) {
  const prepareAdapter = params.prepareAdapter ?? (e => e);
  const adapter = new Adapter();
  const adapterTZ = params.dateLibInstanceWithTimezoneSupport ? new Adapter({
    dateLibInstance: params.dateLibInstanceWithTimezoneSupport
  }) : new Adapter();
  const adapterFr = new Adapter({
    locale: params.frenchLocale,
    dateLibInstance: params.dateLibInstanceWithTimezoneSupport
  });
  prepareAdapter(adapter);
  prepareAdapter(adapterTZ);
  describe(adapter.lib, () => {
    const testSuitParams = (0, _extends2.default)({}, params, {
      adapter,
      adapterTZ,
      adapterFr
    });
    (0, _testCalculations.testCalculations)(testSuitParams);
    (0, _testLocalization.testLocalization)(testSuitParams);
    (0, _testFormat.testFormat)(testSuitParams);
  });
}
const describeGregorianAdapter = (0, _createDescribe.default)('Adapter methods', innerGregorianDescribeAdapter);
exports.describeGregorianAdapter = describeGregorianAdapter;