import { getPickersLocalization } from './utils/getPickersLocalization';
// Translation map for Clock Label
var timeViews = {
  hours: 'Сағатты',
  minutes: 'Минутты',
  seconds: 'Секундты',
  meridiem: 'Меридием'
};
var kzKZPickers = {
  // Calendar navigation
  previousMonth: 'Алдыңғы ай',
  nextMonth: 'Келесі ай',
  // View navigation
  openPreviousView: 'Алдыңғы көріністі ашу',
  openNextView: 'Келесі көріністі ашу',
  calendarViewSwitchingButtonAriaLabel: function calendarViewSwitchingButtonAriaLabel(view) {
    return view === 'year' ? 'жылдық көріністі ашу, күнтізбе көрінісіне ауысу' : 'күнтізбе көрінісін ашу, жылдық көрінісіне ауысу';
  },
  // DateRange placeholders
  start: 'Бастау',
  end: 'Cоңы',
  // Action bar
  cancelButtonLabel: 'Бас тарту',
  clearButtonLabel: 'Тазарту',
  okButtonLabel: 'Ок',
  todayButtonLabel: 'Бүгін',
  // Toolbar titles
  datePickerToolbarTitle: 'Күнді таңдау',
  dateTimePickerToolbarTitle: 'Күн мен уақытты таңдау',
  timePickerToolbarTitle: 'Уақытты таңдау',
  dateRangePickerToolbarTitle: 'Кезеңді таңдаңыз',
  // Clock labels
  clockLabelText: function clockLabelText(view, time, adapter) {
    return "".concat(timeViews[view], " \u0442\u0430\u04A3\u0434\u0430\u0443. ").concat(time === null ? 'Уақыт таңдалмаған' : "\u0422\u0430\u04A3\u0434\u0430\u043B\u0493\u0430\u043D \u0443\u0430\u049B\u044B\u0442 ".concat(adapter.format(time, 'fullTime')));
  },
  hoursClockNumberText: function hoursClockNumberText(hours) {
    return "".concat(hours, " \u0441\u0430\u0493\u0430\u0442");
  },
  minutesClockNumberText: function minutesClockNumberText(minutes) {
    return "".concat(minutes, " \u043C\u0438\u043D\u0443\u0442");
  },
  secondsClockNumberText: function secondsClockNumberText(seconds) {
    return "".concat(seconds, " \u0441\u0435\u043A\u0443\u043D\u0434");
  },
  // Digital clock labels
  selectViewText: function selectViewText(view) {
    return "".concat(timeViews[view], " \u0442\u0430\u04A3\u0434\u0430\u0443");
  },
  // Calendar labels
  calendarWeekNumberHeaderLabel: 'Апта нөмірі',
  calendarWeekNumberHeaderText: '№',
  calendarWeekNumberAriaLabelText: function calendarWeekNumberAriaLabelText(weekNumber) {
    return "\u0410\u043F\u0442\u0430 ".concat(weekNumber);
  },
  calendarWeekNumberText: function calendarWeekNumberText(weekNumber) {
    return "".concat(weekNumber);
  },
  // Open picker labels
  openDatePickerDialogue: function openDatePickerDialogue(value, utils) {
    return value !== null && utils.isValid(value) ? "\u041A\u04AF\u043D\u0434\u0456 \u0442\u0430\u04A3\u0434\u0430\u04A3\u044B\u0437, \u0442\u0430\u04A3\u0434\u0430\u043B\u0493\u0430\u043D \u043A\u04AF\u043D ".concat(utils.format(value, 'fullDate')) : 'Күнді таңдаңыз';
  },
  openTimePickerDialogue: function openTimePickerDialogue(value, utils) {
    return value !== null && utils.isValid(value) ? "\u0423\u0430\u049B\u044B\u0442\u0442\u044B \u0442\u0430\u04A3\u0434\u0430\u04A3\u044B\u0437, \u0442\u0430\u04A3\u0434\u0430\u043B\u0493\u0430\u043D \u0443\u0430\u049B\u044B\u0442 ".concat(utils.format(value, 'fullTime')) : 'Уақытты таңдаңыз';
  },
  // Table labels
  timeTableLabel: 'уақытты таңдау',
  dateTableLabel: 'күнді таңдау',
  // Field section placeholders
  fieldYearPlaceholder: function fieldYearPlaceholder(params) {
    return 'Ж'.repeat(params.digitAmount);
  },
  fieldMonthPlaceholder: function fieldMonthPlaceholder(params) {
    return params.contentType === 'letter' ? 'AAAA' : 'AA';
  },
  fieldDayPlaceholder: function fieldDayPlaceholder() {
    return 'КК';
  },
  // fieldWeekDayPlaceholder: params => params.contentType === 'letter' ? 'EEEE' : 'EE',
  fieldHoursPlaceholder: function fieldHoursPlaceholder() {
    return 'сс';
  },
  fieldMinutesPlaceholder: function fieldMinutesPlaceholder() {
    return 'мм';
  },
  fieldSecondsPlaceholder: function fieldSecondsPlaceholder() {
    return 'сс';
  },
  fieldMeridiemPlaceholder: function fieldMeridiemPlaceholder() {
    return '(т|к)';
  }
};
export var kzKZ = getPickersLocalization(kzKZPickers);