import { expect } from 'chai';
import { stub } from 'sinon';
import { cleanText } from 'test/utils/pickers';
import { TEST_DATE_ISO_STRING } from './describeGregorianAdapter.utils';
export var testLocalization = function testLocalization(_ref) {
  var adapter = _ref.adapter;
  var testDateIso = adapter.date(TEST_DATE_ISO_STRING);
  it('Method: formatNumber', function () {
    expect(adapter.formatNumber('1')).to.equal('1');
  });
  it('Method: getMeridiemText', function () {
    expect(adapter.getMeridiemText('am')).to.equal('AM');
    expect(adapter.getMeridiemText('pm')).to.equal('PM');

    // Moment only translates for 12-hour cycle.
    if (adapter.lib === 'moment') {
      var sinonStub = stub(adapter, 'is12HourCycleInCurrentLocale').returns(false);
      expect(adapter.getMeridiemText('am')).to.equal('AM');
      expect(adapter.getMeridiemText('pm')).to.equal('PM');
      sinonStub.restore();
    }
  });
  it('Method: expandFormat', function () {
    var testFormat = function testFormat(formatKey) {
      var formatString = adapter.formats[formatKey];
      var expandedFormat = cleanText(adapter.expandFormat(formatString));
      if (expandedFormat === formatString) {
        return;
      }

      // The expanded format should be fully expanded
      expect(cleanText(adapter.expandFormat(expandedFormat))).to.equal(expandedFormat);

      // Both format should be equivalent
      expect(cleanText(adapter.formatByString(testDateIso, expandedFormat))).to.equal(cleanText(adapter.format(testDateIso, formatKey)));
    };
    Object.keys(adapter.formats).forEach(function (formatKey) {
      testFormat(formatKey);
    });
  });
  it('Method: getFormatHelperText', function () {
    expect(adapter.getFormatHelperText(adapter.formats.keyboardDate)).to.equal(adapter.lib === 'luxon' ? 'm/d/yyyy' : 'mm/dd/yyyy');
    expect(adapter.getFormatHelperText(adapter.formats.keyboardDateTime12h)).to.equal(adapter.lib === 'luxon' ? 'm/d/yyyy hh:mm (a|p)m' : 'mm/dd/yyyy hh:mm (a|p)m');
  });
  it('Method: getCurrentLocaleCode', function () {
    // Returns the default locale
    expect(adapter.getCurrentLocaleCode()).to.match(/en/);
  });
};