import { DateTime } from 'luxon';
import { AdapterFormats, AdapterOptions, AdapterUnits, DateBuilderReturnType, FieldFormatTokenMap, MuiPickersAdapter, PickersTimezone } from '../models';
/**
 * Based on `@date-io/luxon`
 *
 * MIT License
 *
 * Copyright (c) 2017 Dmitriy Kovalenko
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
export declare class AdapterLuxon implements MuiPickersAdapter<DateTime, string> {
    isMUIAdapter: boolean;
    isTimezoneCompatible: boolean;
    lib: string;
    locale: string;
    formats: AdapterFormats;
    escapedCharacters: {
        start: string;
        end: string;
    };
    formatTokenMap: FieldFormatTokenMap;
    constructor({ locale, formats }?: AdapterOptions<string, never>);
    private setLocaleToValue;
    date: (value?: any) => DateTime | null;
    dateWithTimezone: <T extends string | null | undefined>(value: T, timezone: PickersTimezone) => DateBuilderReturnType<T, DateTime>;
    getTimezone: (value: DateTime) => string;
    setTimezone: (value: DateTime, timezone: PickersTimezone) => DateTime;
    toJsDate: (value: DateTime) => Date;
    parseISO: (isoString: string) => DateTime;
    toISO: (value: DateTime) => string;
    parse: (value: string, formatString: string) => DateTime | null;
    getCurrentLocaleCode: () => string;
    is12HourCycleInCurrentLocale: () => boolean;
    expandFormat: (format: string) => string;
    getFormatHelperText: (format: string) => string;
    isNull: (value: DateTime | null) => boolean;
    isValid: (value: any) => boolean;
    format: (value: DateTime, formatKey: keyof AdapterFormats) => string;
    formatByString: (value: DateTime, format: string) => string;
    formatNumber: (numberToFormat: string) => string;
    getDiff: (value: DateTime, comparing: DateTime | string, unit?: AdapterUnits) => number;
    isEqual: (value: any, comparing: any) => boolean;
    isSameYear: (value: DateTime, comparing: DateTime) => boolean;
    isSameMonth: (value: DateTime, comparing: DateTime) => boolean;
    isSameDay: (value: DateTime, comparing: DateTime) => boolean;
    isSameHour: (value: DateTime, comparing: DateTime) => boolean;
    isAfter: (value: DateTime, comparing: DateTime) => boolean;
    isAfterYear: (value: DateTime, comparing: DateTime) => boolean;
    isAfterDay: (value: DateTime, comparing: DateTime) => boolean;
    isBefore: (value: DateTime, comparing: DateTime) => boolean;
    isBeforeYear: (value: DateTime, comparing: DateTime) => boolean;
    isBeforeDay: (value: DateTime, comparing: DateTime) => boolean;
    isWithinRange: (value: DateTime, [start, end]: [DateTime, DateTime]) => boolean;
    startOfYear: (value: DateTime) => DateTime;
    startOfMonth: (value: DateTime) => DateTime;
    startOfWeek: (value: DateTime) => DateTime;
    startOfDay: (value: DateTime) => DateTime;
    endOfYear: (value: DateTime) => DateTime;
    endOfMonth: (value: DateTime) => DateTime;
    endOfWeek: (value: DateTime) => DateTime;
    endOfDay: (value: DateTime) => DateTime;
    addYears: (value: DateTime, amount: number) => DateTime;
    addMonths: (value: DateTime, amount: number) => DateTime;
    addWeeks: (value: DateTime, amount: number) => DateTime;
    addDays: (value: DateTime, amount: number) => DateTime;
    addHours: (value: DateTime, amount: number) => DateTime;
    addMinutes: (value: DateTime, amount: number) => DateTime;
    addSeconds: (value: DateTime, amount: number) => DateTime;
    getYear: (value: DateTime) => number;
    getMonth: (value: DateTime) => number;
    getDate: (value: DateTime) => number;
    getHours: (value: DateTime) => number;
    getMinutes: (value: DateTime) => number;
    getSeconds: (value: DateTime) => number;
    getMilliseconds: (value: DateTime) => number;
    setYear: (value: DateTime, year: number) => DateTime;
    setMonth: (value: DateTime, month: number) => DateTime;
    setDate: (value: DateTime, date: number) => DateTime;
    setHours: (value: DateTime, hours: number) => DateTime;
    setMinutes: (value: DateTime, minutes: number) => DateTime;
    setSeconds: (value: DateTime, seconds: number) => DateTime;
    setMilliseconds: (value: DateTime, milliseconds: number) => DateTime;
    getDaysInMonth: (value: DateTime) => import("luxon").PossibleDaysInMonth;
    getNextMonth: (value: DateTime) => DateTime;
    getPreviousMonth: (value: DateTime) => DateTime;
    getMonthArray: (value: DateTime) => DateTime[];
    mergeDateAndTime: (dateParam: DateTime, timeParam: DateTime) => DateTime;
    getWeekdays: () => string[];
    getWeekArray: (value: DateTime) => DateTime[][];
    getWeekNumber: (value: DateTime) => number;
    getYearRange: (start: DateTime, end: DateTime) => DateTime[];
    getMeridiemText: (ampm: 'am' | 'pm') => string;
}
