"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testTextFieldValidation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _sinon = require("sinon");
var _utils = require("@mui/monorepo/test/utils");
var _pickers = require("test/utils/pickers");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testTextFieldValidation = (ElementToTest, getOptions) => {
  const {
    componentFamily,
    render,
    withDate,
    withTime
  } = getOptions();
  if (!['picker', 'field'].includes(componentFamily)) {
    return;
  }
  describe('text field:', () => {
    it('should apply shouldDisableDate', function test() {
      if (['picker', 'field'].includes(componentFamily) && !withDate) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12)),
        shouldDisableDate: date => _pickers.adapterToUse.isAfter(date, _pickers.adapterToUse.date(new Date(2018, 2, 10)))
      }));
      if (withDate) {
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
        (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableDate');
        setProps({
          value: _pickers.adapterToUse.date(new Date(2018, 2, 9))
        });
        (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      } else {
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
      }
    });
    it('should apply shouldDisableYear', function test() {
      if (!withDate) {
        // Early return to remove when DateTimePickers will support those props
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12)),
        shouldDisableYear: date => _pickers.adapterToUse.getYear(date) === 2018
      }));
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableYear');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 2, 9))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
    });
    it('should apply shouldDisableMonth', function test() {
      if (!withDate) {
        // Early return to remove when DateTimePickers will support those props
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        shouldDisableMonth: date => _pickers.adapterToUse.getMonth(date) === 2,
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12))
      }));
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableMonth');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 2, 9))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 3, 9))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
    });
    it('should apply shouldDisableClock', function test() {
      if (!withTime) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        shouldDisableClock: value => value === 10,
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 10, 5, 0))
      }));
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableClock-hours');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 2, 12, 9, 5, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 9, 10, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(3);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableClock-minutes');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 9, 9, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(4);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 9, 9, 10))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(5);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableClock-seconds');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
    });
    it('should apply shouldDisableTime', function test() {
      if (!withTime) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        shouldDisableTime: (value, view) => {
          let comparingValue = _pickers.adapterToUse.getHours(value);
          if (view === 'minutes') {
            comparingValue = _pickers.adapterToUse.getMinutes(value);
          } else if (view === 'seconds') {
            comparingValue = _pickers.adapterToUse.getSeconds(value);
          }
          return comparingValue === 10;
        },
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 10, 5, 0))
      }));
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableTime-hours');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 2, 12, 9, 5, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 9, 10, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(3);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableTime-minutes');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 9, 9, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(4);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      setProps({
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 9, 9, 10))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(5);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('shouldDisableTime-seconds');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
    });
    it('should apply disablePast', function test() {
      if (!withDate) {
        return;
      }
      let now;
      function WithFakeTimer(props) {
        now = _pickers.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, {
        disablePast: true,
        onError: onErrorMock
      }));
      const tomorrow = _pickers.adapterToUse.addDays(now, 1);
      const yesterday = _pickers.adapterToUse.addDays(now, -1);
      (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      setProps({
        value: yesterday
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('disablePast');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: tomorrow
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
    });
    it('should apply disableFuture', function test() {
      if (!withDate) {
        return;
      }
      let now;
      function WithFakeTimer(props) {
        now = _pickers.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, {
        disableFuture: true,
        onError: onErrorMock
      }));
      const tomorrow = _pickers.adapterToUse.addDays(now, 1);
      const yesterday = _pickers.adapterToUse.addDays(now, -1);
      (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      setProps({
        value: tomorrow
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('disableFuture');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      setProps({
        value: yesterday
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
    });
    it('should apply minDate', function test() {
      if (['picker', 'field'].includes(componentFamily) && !withDate) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2019, 5, 1)),
        minDate: _pickers.adapterToUse.date(new Date(2019, 5, 15))
      }));
      if (withDate) {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('minDate');
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
        setProps({
          value: _pickers.adapterToUse.date(new Date(2019, 5, 20))
        });
        (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      } else {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      }
    });
    it('should apply maxDate', function test() {
      if (['picker', 'field'].includes(componentFamily) && !withDate) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2019, 5, 25)),
        maxDate: _pickers.adapterToUse.date(new Date(2019, 5, 15))
      }));
      if (withDate) {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('maxDate');
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
        setProps({
          value: _pickers.adapterToUse.date(new Date(2019, 5, 10))
        });
        (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      } else {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      }
    });
    it('should apply minTime', function test() {
      if (['picker', 'field'].includes(componentFamily) && !withTime) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 10, 15)),
        minTime: _pickers.adapterToUse.date(new Date(2010, 0, 1, 12, 0))
      }));
      if (withTime) {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('minTime');
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
        setProps({
          value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 13, 10))
        });
        (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      } else {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      }
    });
    it('should apply maxTime', function test() {
      if (['picker', 'field'].includes(componentFamily) && !withTime) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        maxTime: _pickers.adapterToUse.date(new Date(2010, 0, 1, 12, 0)),
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 10, 15))
      }));
      if (withTime) {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
        setProps({
          value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 13, 10))
        });
        (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('maxTime');
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
      } else {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      }
    });
    it('should apply maxDateTime', function test() {
      if (!withDate || !withTime) {
        // prop only available on DateTime pickers
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 13, 15)),
        maxDateTime: _pickers.adapterToUse.date(new Date(2019, 5, 15, 12, 0))
      }));
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('maxTime');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');

      // Test 5 minutes before
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 11, 55))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');

      // Test 1 day before
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 5, 14, 20, 10))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');

      // Test 1 day after
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 5, 16, 10, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(3);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('maxDate');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
    });
    it('should apply minDateTime', function test() {
      if (!withDate || !withTime) {
        // prop only available on DateTime pickers
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 13, 15)),
        minDateTime: _pickers.adapterToUse.date(new Date(2019, 5, 15, 12, 0))
      }));
      (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');

      // Test 5 minutes before (invalid)
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 11, 55))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('minTime');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');

      // Test 1 day before (invalid)
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 5, 14, 20, 10))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('minDate');
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');

      // Test 1 day after
      setProps({
        value: _pickers.adapterToUse.date(new Date(2019, 5, 16, 10, 0))
      });
      (0, _chai.expect)(onErrorMock.callCount).to.equal(3);
      (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
      (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
    });
    it('should apply minutesStep', function test() {
      if (['picker', 'field'].includes(componentFamily) && !withTime) {
        return;
      }
      const onErrorMock = (0, _sinon.spy)();
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onError: onErrorMock,
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 10, 15)),
        minutesStep: 30
      }));
      if (withTime) {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(1);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal('minutesStep');
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'true');
        setProps({
          value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 10, 30))
        });
        (0, _chai.expect)(onErrorMock.callCount).to.equal(2);
        (0, _chai.expect)(onErrorMock.lastCall.args[0]).to.equal(null);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      } else {
        (0, _chai.expect)(onErrorMock.callCount).to.equal(0);
        (0, _chai.expect)(_utils.screen.getByRole('textbox')).to.have.attribute('aria-invalid', 'false');
      }
    });
  });
};
exports.testTextFieldValidation = testTextFieldValidation;