"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testMinutesViewValidation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _utils = require("@mui/monorepo/test/utils");
var _pickers = require("test/utils/pickers");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const toMinutesLabel = minutes => `${Number(minutes) < 10 ? `0${minutes}` : minutes} minutes`;
const testMinutesViewValidation = (ElementToTest, getOption) => {
  const {
    componentFamily,
    views,
    render,
    clock,
    withDate,
    withTime,
    variant
  } = getOption();
  if (!views.includes('minutes') || !variant || componentFamily !== 'picker' || variant === 'desktop') {
    return;
  }
  describe('minutes view:', () => {
    const defaultProps = {
      onChange: () => {},
      open: true,
      view: 'minutes',
      openTo: 'minutes',
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    };
    it('should apply shouldDisableTime', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickers.adapterToUse.date(new Date(2018, 2, 12, 8, 15, 0)),
        shouldDisableTime: date => _pickers.adapterToUse.isAfter(date, _pickers.adapterToUse.date(new Date(2018, 2, 12, 8, 20, 0)))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('10')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('15')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('20')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('25')
      })).to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('30')
      })).to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('55')
      })).to.have.attribute('aria-disabled');
    });
    it('should apply disablePast', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickers.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disablePast: true
      })));
      const tomorrow = _pickers.adapterToUse.addDays(now, 1);
      const currentMinutes = _pickers.adapterToUse.getMinutes(now);
      const closestNowMinutesOptionValue = Math.floor(currentMinutes / 5) * 5;
      const previousMinutesOptionValue = Math.floor(currentMinutes / 5) * 5 - 5;
      const nextMinutesOptionValue = Math.floor(currentMinutes / 5) * 5 + 5;
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(previousMinutesOptionValue)
      })).to.have.attribute('aria-disabled');
      if (currentMinutes <= closestNowMinutesOptionValue) {
        (0, _chai.expect)(_utils.screen.getByRole('option', {
          name: toMinutesLabel(closestNowMinutesOptionValue)
        })).not.to.have.attribute('aria-disabled');
      } else {
        (0, _chai.expect)(_utils.screen.getByRole('option', {
          name: toMinutesLabel(closestNowMinutesOptionValue)
        })).to.have.attribute('aria-disabled');
      }
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(nextMinutesOptionValue)
      })).not.to.have.attribute('aria-disabled');

      // following validation is relevant only for DateTimePicker
      if (!withDate || !withTime) {
        return;
      }
      setProps({
        value: tomorrow
      });
      clock.runToLast();
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(previousMinutesOptionValue)
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(closestNowMinutesOptionValue)
      })).not.to.have.attribute('aria-disabled');
    });
    it('should apply disableFuture', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickers.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disableFuture: true
      })));
      const yesterday = _pickers.adapterToUse.addDays(now, -1);
      const currentMinutes = _pickers.adapterToUse.getMinutes(now);
      const closestNowMinutesOptionValue = Math.floor(currentMinutes / 5) * 5;
      const previousMinutesOptionValue = Math.floor(currentMinutes / 5) * 5 - 5;
      const nextMinutesOptionValue = Math.floor(currentMinutes / 5) * 5 + 5;
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(previousMinutesOptionValue)
      })).not.to.have.attribute('aria-disabled');
      if (currentMinutes < closestNowMinutesOptionValue) {
        (0, _chai.expect)(_utils.screen.getByRole('option', {
          name: toMinutesLabel(closestNowMinutesOptionValue)
        })).to.have.attribute('aria-disabled');
      } else {
        (0, _chai.expect)(_utils.screen.getByRole('option', {
          name: toMinutesLabel(closestNowMinutesOptionValue)
        })).not.to.have.attribute('aria-disabled');
      }
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(nextMinutesOptionValue)
      })).to.have.attribute('aria-disabled');

      // following validation is relevant only for DateTimePicker
      if (!withDate || !withTime) {
        return;
      }
      setProps({
        value: yesterday
      });
      clock.runToLast();
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(previousMinutesOptionValue)
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel(closestNowMinutesOptionValue)
      })).not.to.have.attribute('aria-disabled');
    });
    it('should apply maxTime', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 11, 15, 0)),
        maxTime: _pickers.adapterToUse.date(new Date(2019, 5, 15, 11, 20, 0))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('10')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('15')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('20')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('25')
      })).to.have.attribute('aria-disabled');
    });
    it('should apply minTime', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickers.adapterToUse.date(new Date(2019, 5, 15, 11, 15, 0)),
        minTime: _pickers.adapterToUse.date(new Date(2019, 5, 15, 11, 10, 0))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('0')
      })).to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('5')
      })).to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('10')
      })).not.to.have.attribute('aria-disabled');
      (0, _chai.expect)(_utils.screen.getByRole('option', {
        name: toMinutesLabel('15')
      })).not.to.have.attribute('aria-disabled');
    });
  });
};
exports.testMinutesViewValidation = testMinutesViewValidation;