"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describeAdapters = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _moment = _interopRequireDefault(require("moment"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _createDescribe = _interopRequireDefault(require("@mui/monorepo/test/utils/createDescribe"));
var _pickers = require("test/utils/pickers");
const ADAPTERS = ['dayjs', 'date-fns', 'luxon', 'moment'];
function innerDescribeAdapters(title, FieldComponent, testRunner) {
  ADAPTERS.forEach(adapterName => {
    // TODO: Set locale moment before the 1st test run
    if (adapterName === 'moment') {
      _moment.default.locale('en');
    }
    describe(`${title} - adapter: ${adapterName}`, () => {
      const pickerRendererResponse = (0, _pickers.createPickerRenderer)({
        adapterName,
        clock: 'fake',
        clockConfig: new Date(2022, 5, 15),
        instance: adapterName === 'moment' ? _momentTimezone.default : undefined
      });
      const fieldInteractions = (0, _pickers.buildFieldInteractions)({
        clock: pickerRendererResponse.clock,
        render: pickerRendererResponse.render,
        Component: FieldComponent
      });
      testRunner((0, _extends2.default)({}, pickerRendererResponse, fieldInteractions));
    });
  });
}
const describeAdapters = (0, _createDescribe.default)('Adapter specific tests', innerDescribeAdapters);
exports.describeAdapters = describeAdapters;