import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
const _excluded = ["hook"];
import * as React from 'react';
import createDescribe from '@mui/monorepo/test/utils/createDescribe';
import { buildFieldInteractions } from 'test/utils/pickers';
import { testControlledUnControlled } from './testControlledUnControlled';
import { testPickerOpenCloseLifeCycle } from './testPickerOpenCloseLifeCycle';
import { testPickerActionBar } from './testPickerActionBar';
import { testShortcuts } from './testShortcuts';
import { jsx as _jsx } from "react/jsx-runtime";
const TEST_SUITES = [testControlledUnControlled, testPickerOpenCloseLifeCycle, testPickerActionBar, testShortcuts];
function innerDescribeValue(ElementToTest, getOptions) {
  const options = getOptions();
  const {
    defaultProps,
    render,
    clock,
    componentFamily
  } = options;
  function WrappedElementToTest(props) {
    const {
        hook
      } = props,
      other = _objectWithoutPropertiesLoose(props, _excluded);
    const hookResult = hook?.(props);
    return /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, other, hookResult));
  }
  let renderWithProps;
  if (componentFamily === 'field' || componentFamily === 'picker') {
    const interactions = buildFieldInteractions({
      clock,
      render,
      Component: ElementToTest
    });
    renderWithProps = (props, hook) => interactions.renderWithProps(_extends({}, defaultProps, props), hook, componentFamily);
  } else {
    renderWithProps = (props, hook) => {
      const response = render( /*#__PURE__*/_jsx(WrappedElementToTest, _extends({}, props, {
        hook: hook
      })));
      return _extends({}, response, {
        input: null,
        selectSection: () => {
          throw new Error('You can only select a section on components that render a field');
        }
      });
    };
  }
  TEST_SUITES.forEach(testSuite => {
    testSuite(WrappedElementToTest, _extends({}, options, {
      renderWithProps
    }));
  });
}
/**
 * Tests various aspects of component value.
 */
export const describeValue = createDescribe('Value API', innerDescribeValue);