import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import { expect } from 'chai';
import { screen } from '@mui/monorepo/test/utils';
import { adapterToUse } from 'test/utils/pickers';
import { jsx as _jsx } from "react/jsx-runtime";
export var testYearViewValidation = function testYearViewValidation(ElementToTest, getOptions) {
  var _getOptions = getOptions(),
    views = _getOptions.views,
    componentFamily = _getOptions.componentFamily,
    render = _getOptions.render;
  if (componentFamily === 'field' || !views.includes('year')) {
    return;
  }
  describe('year view:', function () {
    var defaultProps = _extends({
      onChange: function onChange() {}
    }, views.length > 1 && {
      views: ['year'],
      view: 'year',
      openTo: 'year'
    }, componentFamily !== 'calendar' && {
      open: true,
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    });
    it('should apply shouldDisableYear', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: null,
        shouldDisableYear: function shouldDisableYear(date) {
          return adapterToUse.getYear(date) === 2018;
        }
      })));
      expect(screen.queryByText('2018')).to.have.attribute('disabled');
      expect(screen.queryByText('2019')).not.to.have.attribute('disabled');
      expect(screen.queryByText('2017')).not.to.have.attribute('disabled');
    });
    it('should apply disablePast', function test() {
      var now;
      function WithFakeTimer(props) {
        now = adapterToUse.date(new Date());
        return /*#__PURE__*/_jsx(ElementToTest, _extends({
          value: now
        }, props));
      }
      render( /*#__PURE__*/_jsx(WithFakeTimer, _extends({}, defaultProps, {
        disablePast: true
      })));
      var nextYear = adapterToUse.addYears(now, 1);
      var prevYear = adapterToUse.addYears(now, -1);
      expect(screen.queryByText(adapterToUse.format(now, 'year'))).not.to.have.attribute('disabled');
      expect(screen.queryByText(adapterToUse.format(nextYear, 'year'))).not.to.have.attribute('disabled');
      expect(screen.queryByText(adapterToUse.format(prevYear, 'year'))).to.have.attribute('disabled');
    });
    it('should apply disableFuture', function test() {
      var now;
      function WithFakeTimer(props) {
        now = adapterToUse.date(new Date());
        return /*#__PURE__*/_jsx(ElementToTest, _extends({
          value: now
        }, props));
      }
      render( /*#__PURE__*/_jsx(WithFakeTimer, _extends({}, defaultProps, {
        disableFuture: true
      })));
      var nextYear = adapterToUse.addYears(now, 1);
      var prevYear = adapterToUse.addYears(now, -1);
      expect(screen.queryByText(adapterToUse.format(now, 'year'))).not.to.have.attribute('disabled');
      expect(screen.queryByText(adapterToUse.format(nextYear, 'year'))).to.have.attribute('disabled');
      expect(screen.queryByText(adapterToUse.format(prevYear, 'year'))).not.to.have.attribute('disabled');
    });
    it('should apply minDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        minDate: adapterToUse.date(new Date(2019, 5, 4))
      })));
      expect(screen.queryByText('2018')).to.equal(null);
      expect(screen.queryByText('2019')).not.to.equal(null);
      expect(screen.queryByText('2020')).not.to.equal(null);
    });
    it('should apply maxDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        maxDate: adapterToUse.date(new Date(2019, 5, 4))
      })));
      expect(screen.queryByText('2018')).not.to.equal(null);
      expect(screen.queryByText('2019')).not.to.equal(null);
      expect(screen.queryByText('2020')).to.equal(null);
    });
  });
};