import _extends from "@babel/runtime/helpers/esm/extends";
import { expect } from 'chai';
import * as React from 'react';
import { screen } from '@mui/monorepo/test/utils';
import { adapterToUse } from 'test/utils/pickers';
import { jsx as _jsx } from "react/jsx-runtime";
export var testDayViewValidation = function testDayViewValidation(ElementToTest, getOptions) {
  var _getOptions = getOptions(),
    componentFamily = _getOptions.componentFamily,
    views = _getOptions.views,
    render = _getOptions.render,
    clock = _getOptions.clock,
    withDate = _getOptions.withDate,
    withTime = _getOptions.withTime;
  if (componentFamily === 'field' || !views.includes('day')) {
    return;
  }
  describe('day view:', function () {
    var defaultProps = {
      onChange: function onChange() {},
      open: true,
      view: 'day',
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    };
    it('should apply shouldDisableDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2018, 2, 12)),
        shouldDisableDate: function shouldDisableDate(date) {
          return adapterToUse.isAfter(date, adapterToUse.date(new Date(2018, 2, 10)));
        }
      })));
      expect(screen.getByRole('gridcell', {
        name: '9'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '10'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '11'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '12'
      })).to.have.attribute('disabled');
    });
    it('should apply shouldDisableYear', function test() {
      var _render = render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
          value: adapterToUse.date(new Date(2018, 2, 12)),
          shouldDisableYear: function shouldDisableYear(date) {
            return adapterToUse.getYear(date) === 2018;
          }
        }))),
        setProps = _render.setProps;
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '15'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
      setProps({
        value: adapterToUse.date(new Date(2019, 0, 1))
      });
      clock.runToLast();
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '15'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).not.to.have.attribute('disabled');
    });
    it('should apply shouldDisableMonth', function test() {
      var _render2 = render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
          value: adapterToUse.date(new Date(2018, 2, 12)),
          shouldDisableMonth: function shouldDisableMonth(date) {
            return adapterToUse.getMonth(date) === 2;
          }
        }))),
        setProps = _render2.setProps;
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '15'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
      setProps({
        value: adapterToUse.date(new Date(2018, 1, 1))
      });
      clock.runToLast();
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '15'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '28'
      })).not.to.have.attribute('disabled');
    });
    it('should apply disablePast', function test() {
      var now;
      function WithFakeTimer(props) {
        now = adapterToUse.date(new Date());
        return /*#__PURE__*/_jsx(ElementToTest, _extends({
          value: now
        }, props));
      }
      var _render3 = render( /*#__PURE__*/_jsx(WithFakeTimer, _extends({}, defaultProps, {
          disablePast: true
        }))),
        setProps = _render3.setProps;
      var tomorrow = adapterToUse.addDays(now, 1);
      var yesterday = adapterToUse.addDays(now, -1);
      expect(screen.getByRole('gridcell', {
        name: adapterToUse.format(now, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
      if (!adapterToUse.isSameMonth(now, tomorrow)) {
        setProps({
          value: tomorrow
        });
        clock.runToLast();
      }
      expect(screen.getByRole('gridcell', {
        name: adapterToUse.format(tomorrow, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
      if (!adapterToUse.isSameMonth(yesterday, tomorrow)) {
        setProps({
          value: yesterday
        });
        clock.runToLast();
      }
      expect(screen.getByRole('gridcell', {
        name: adapterToUse.format(yesterday, 'dayOfMonth')
      })).to.have.attribute('disabled');
    });
    it('should apply disableFuture', function test() {
      var now;
      function WithFakeTimer(props) {
        now = adapterToUse.date(new Date());
        return /*#__PURE__*/_jsx(ElementToTest, _extends({
          value: now
        }, props));
      }
      var _render4 = render( /*#__PURE__*/_jsx(WithFakeTimer, _extends({}, defaultProps, {
          disableFuture: true
        }))),
        setProps = _render4.setProps;
      var tomorrow = adapterToUse.addDays(now, 1);
      var yesterday = adapterToUse.addDays(now, -1);
      expect(screen.getByRole('gridcell', {
        name: adapterToUse.format(now, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
      if (!adapterToUse.isSameMonth(now, tomorrow)) {
        setProps({
          value: tomorrow
        });
        clock.runToLast();
      }
      expect(screen.getByRole('gridcell', {
        name: adapterToUse.format(tomorrow, 'dayOfMonth')
      })).to.have.attribute('disabled');
      if (!adapterToUse.isSameMonth(yesterday, tomorrow)) {
        setProps({
          value: yesterday
        });
        clock.runToLast();
      }
      expect(screen.getByRole('gridcell', {
        name: adapterToUse.format(yesterday, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
    });
    it('should apply minDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        minDate: adapterToUse.date(new Date(2019, 5, 4))
      })));
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '3'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '5'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).not.to.have.attribute('disabled');
      expect(screen.getByLabelText('Previous month')).to.have.attribute('disabled');
      expect(screen.getByLabelText('Next month')).not.to.have.attribute('disabled');
    });
    it('should apply maxDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        maxDate: adapterToUse.date(new Date(2019, 5, 4))
      })));
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '3'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '5'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
      expect(screen.getByLabelText('Previous month')).not.to.have.attribute('disabled');
      expect(screen.getByLabelText('Next month')).to.have.attribute('disabled');
    });
    it('should apply maxDateTime', function test() {
      if (!withDate || !withTime) {
        // prop only available on DateTime pickers
        return;
      }
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        maxDateTime: adapterToUse.date(new Date(2019, 5, 4, 12, 0, 0))
      })));
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '3'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '5'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
    });
    it('should apply minDateTime', function test() {
      if (!withDate || !withTime) {
        // prop only available on DateTime pickers
        return;
      }
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        minDateTime: adapterToUse.date(new Date(2019, 5, 4, 12, 0, 0))
      })));
      expect(screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '3'
      })).to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '5'
      })).not.to.have.attribute('disabled');
      expect(screen.getByRole('gridcell', {
        name: '30'
      })).not.to.have.attribute('disabled');
    });
  });
};