import _extends from "@babel/runtime/helpers/esm/extends";
import moment from 'moment';
import momentTZ from 'moment-timezone';
import createDescribe from '@mui/monorepo/test/utils/createDescribe';
import { buildFieldInteractions, createPickerRenderer } from 'test/utils/pickers';
var ADAPTERS = ['dayjs', 'date-fns', 'luxon', 'moment'];
function innerDescribeAdapters(title, FieldComponent, testRunner) {
  ADAPTERS.forEach(function (adapterName) {
    // TODO: Set locale moment before the 1st test run
    if (adapterName === 'moment') {
      moment.locale('en');
    }
    describe("".concat(title, " - adapter: ").concat(adapterName), function () {
      var pickerRendererResponse = createPickerRenderer({
        adapterName: adapterName,
        clock: 'fake',
        clockConfig: new Date(2022, 5, 15),
        instance: adapterName === 'moment' ? momentTZ : undefined
      });
      var fieldInteractions = buildFieldInteractions({
        clock: pickerRendererResponse.clock,
        render: pickerRendererResponse.render,
        Component: FieldComponent
      });
      testRunner(_extends({}, pickerRendererResponse, fieldInteractions));
    });
  });
}
export var describeAdapters = createDescribe('Adapter specific tests', innerDescribeAdapters);