# run this on homeserver, after installing HPI from https://github.com/srajangarg/my-data

import my.reddit.all
import uuid
import json
from datetime import datetime
def generate_annotations_reddit(output_file):
    annotations = []

    for saved in my.reddit.all.saved():
        annotation = {
            "selection": {
                "type": "page"
            },
            "url": saved.url,
            "group": f"reddit-saved-{saved.subreddit}",
            "timestamp": datetime.strftime(saved.created, '%Y-%m-%dT%H:%M:%S.%f')[:-3] + 'Z',
            "annotation": "",
            "id": str(uuid.uuid4())
        }
        annotations.append(annotation)

    with open(output_file, 'w') as f:
        json.dump(annotations, f, indent=2, ensure_ascii=False)

if __name__ == "__main__":
    output_file = "reddit_annotations.json"
    generate_annotations_reddit(output_file)
