#!/bin/bash

# Configuration
API_URL="http://192.168.1.159:3000"
EMAIL="srajan.garg@gmail.com"
PASSWORD="stack777"

# Authenticate and extract the token
echo "Authenticating..."
AUTH_RESPONSE=$(curl -s -X POST "${API_URL}/api/v1/auths/signin" \
  -H 'Content-Type: application/json' \
  --data "{
    \"email\": \"${EMAIL}\",
    \"password\": \"${PASSWORD}\"
  }")

# Extract token from the response using jq
TOKEN=$(echo $AUTH_RESPONSE | jq -r '.token')

if [ -z "$TOKEN" ]; then
    echo "Authentication failed!"
    echo "Response: $AUTH_RESPONSE"
    exit 1
fi

echo "Authentication successful!"

# Fetch all chats and save to file
echo "Fetching chats..."
curl -s -X GET "${API_URL}/api/v1/chats/all/db" \
  -H "Authorization: Bearer ${TOKEN}" \
  -H 'Content-Type: application/json' \
  > /home/garg/my-data/exports/openwebui/all_chats.json

echo "Chats saved to all_chats.json"