from dataclasses import Field
from mirascope.core import openai
from openai import OpenAI
from pydantic import BaseModel

OPENROUTER_API_KEY = "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"

client = OpenAI(
  base_url="https://openrouter.ai/api/v1",
  api_key=OPENROUTER_API_KEY,
)

class VoiceRecordingSummary(BaseModel):
    file_name: str = Field(description="The name of the voice recording")
    summary: str = Field(description="A summary of the voice recording")


@openai.call(model="anthropic/claude-3.7-sonnet", client=client, response_model=VoiceRecordingSummary)
def extract_book(text: str) -> str:
    return f"Extract {text}"


book = extract_book("The Name of the Wind by Patrick Rothfuss")
print(book)